/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class UrlBuilder {
    protected String baseUrl;
    protected List<KeyVal> params;

    public UrlBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
        this.params = new ArrayList<KeyVal>();
    }

    public void addParam(String key, String val) {
        this.params.add(new KeyVal(key, val));
    }

    public void setParam(String key, Integer value) {
        this.setParam(key, value == null ? null : value.toString());
    }

    public void setParam(String key, String value) {
        boolean set = false;
        for (KeyVal kv : this.params) {
            if (!kv.key.equals(key)) continue;
            kv.value = value;
            set = true;
        }
        if (!set) {
            this.addParam(key, value);
        }
    }

    public String buildUrl() throws UnsupportedEncodingException {
        StringBuilder buf = new StringBuilder();
        buf.append(this.baseUrl);
        int x = 0;
        while (x < this.params.size()) {
            if (x == 0) {
                buf.append("?");
            } else {
                buf.append("&");
            }
            buf.append(URLEncoder.encode(this.params.get((int)x).key, "UTF-8"));
            if (this.params.get((int)x).value != null) {
                buf.append("=");
                buf.append(URLEncoder.encode(this.params.get((int)x).value, "UTF-8"));
            }
            ++x;
        }
        return buf.toString();
    }

    public static UrlBuilder create(String u) throws UnsupportedEncodingException {
        String[] params;
        String url = u;
        if (u.indexOf(63) == -1) {
            UrlBuilder b = new UrlBuilder(u);
            return b;
        }
        url = u.substring(0, u.indexOf(63));
        UrlBuilder b = new UrlBuilder(url);
        String strparams = u.substring(u.indexOf(63) + 1);
        String[] stringArray = params = strparams.split("&");
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String p;
            String key = p = stringArray[n2];
            String value = null;
            if (p.contains("=")) {
                String[] toks = p.split("=", 2);
                key = URLDecoder.decode(toks[0], "UTF-8");
                value = URLDecoder.decode(toks[1], "UTF-8");
            }
            b.addParam(key, value);
            ++n2;
        }
        return b;
    }

    public static void main(String[] args) {
        try {
            UrlBuilder b = UrlBuilder.create("https://www.blabla.nl/?hmz=x&jojo=y");
            b.setParam("hmz", "w");
            System.out.println("Test: " + b.buildUrl());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static class KeyVal {
        public String key;
        public String value;

        public KeyVal(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

